# ---
# jupyter:
#   jupytext:
#     text_representation:
#       extension: .py
#       format_name: percent
#       format_version: '1.3'
#       jupytext_version: 1.16.4
#   kernelspec:
#     display_name: Python 3
#     name: python3
# ---

# %% [markdown] id="RQ73d6XVysi7"
# # CDH course "Programming in Python"
#
# **May 2024 edition**
#
# https://tinyurl.com/cdh-python-0524
#
# ![cdh-python-0524-400.png](data:image/png;base64,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)
#
# [Teams channel](https://teams.microsoft.com/l/team/19%3a7fUy9HLO6LExOYQiz81CKmKv3wN7FI7cXyOgyPSz6Xo1%40thread.tacv2/conversations?groupId=5d0856b8-3287-4585-8d42-6b65e5eee6e6&tenantId=d72758a0-a446-4e0f-a0aa-4bf95a4a10e7)
#
# ## Course modules
#
# 1. [Introduction](https://colab.research.google.com/drive/1W8DqryKuOwPKflPnObv4bJtNKknRsvav)
# 2. [Values and expressions](https://colab.research.google.com/drive/1FDQgdJabqIr2sZd1PNchJ_CKGefOrPE_)
# 3. [Conditionals](https://colab.research.google.com/drive/1Lpr5qBYk9bqtAbY6bzfYcbGzCJpWM-ox)
# 4. [Datastructures](https://colab.research.google.com/drive/15YpXew3euXvEtuAlGPX19QAU8MVmWBJI)
# 5. [Assertions](https://colab.research.google.com/drive/1OBdYVZCMXGzb3fCM_FPAqY_IfeDR1kub)
# 6. [Loops](https://colab.research.google.com/drive/1wzbgGKNbZ1Ao0gHjN6jbFnWh0cxp8bQ1)
# 7. [Functions](https://colab.research.google.com/drive/1w7Nor72UAJMVYEZrwAmbOahP8ItV0ggg)
# 8. [Debugging](https://colab.research.google.com/drive/1Rj6qEuT3BFcQwexAxKg3zbAAD6t1cc8p)
# 9. [String manipulation](https://colab.research.google.com/drive/19yTpFfp9uhBb-kAuOmSQY8_LrMtj8Goq)
# 10. [Dictionaries](https://colab.research.google.com/drive/1w2s28vLo26hzppP0Z-kSqniU2eoXJNU3)
# 11. [Working with files](https://colab.research.google.com/drive/1KsFZV-jmfaQnCFevSxIZrd7chm3Z5CJo)
# 12. [Functions, bis](https://colab.research.google.com/drive/1LHPo4gEzyKTPlVAkGifdzh9ahG2mJq6K)
#
#
# ## Extra material
#
# - [Extra exercises for functions](https://colab.research.google.com/drive/1M-KHZ21IYWQnLu0MIT4fmHY1ljLkl2YD)
# - [Text analysis project](https://colab.research.google.com/drive/137MmdbwyxEZqzmjNBsBV-nhEObKjpw2s)
# - [Tips](https://colab.research.google.com/drive/1A5uJwfO4UCKkh0iriw-edy2hopJvE4Jg)
# - [Life after the course](https://colab.research.google.com/drive/1rozd0eDtKEW3QN74pcEQAGqt4CdK6eji)
#
#
# ## Exercise solutions
#
# 1. [Introduction](https://colab.research.google.com/drive/1saiXnH0-kV08n5xkespxrPrtwAXMJf99)
# 2. [Values and expressions](https://colab.research.google.com/drive/1nnt2VGcmOkHlAWco7xes1O3vr2ser9dD)
# 3. [Conditionals](https://colab.research.google.com/drive/1pJi95yhp50gPqgTnNaNvU5lO9WH5CZSs)
# 4. [Datastructures](https://colab.research.google.com/drive/1QI1iIkCyYOC43xuRBiPI3bgRHjiiqi3L)
# 5. [Assertions](https://colab.research.google.com/drive/17cNgIFtvZ9hckZOCjPSNW4g4-HryRXjg)
# 6. [Loops](https://colab.research.google.com/drive/1l_zFm5S1hFD0BhZJQHdgoQ_fpPqFyYG_)
# 7. [Functions](https://colab.research.google.com/drive/16DdxhY37R1rSqOv8fnFEo5zHvc7UH5VK)
# 8. Debugging has no solutions notebook
# 9. [String manipulation](https://colab.research.google.com/drive/1vfoSsG_arMA-m21YgdD6zYQ_7h2iuy45)
# 10. [Dictionaries](https://colab.research.google.com/drive/1ZvLc2Jrkh9uosmliA8IpT4q7YE-amvkW)
# 11. [Working with files](https://colab.research.google.com/drive/1UZywfMphqJx8iB7aFvBH4ePKBh7E_-Hd)
# 12. [Functions, bis](https://colab.research.google.com/drive/1YyQh6jL3QT17Z9Q8jdxZxhZR0gTZDm1a)
#
